<?php 
/*
	Plugin Name: Grankare Addon
	Plugin URI: https://zozothemes.com/
	Description: This is addon for Grankare theme.
	Version: 1.0.2
	Author: zozothemes
	Author URI: https://zozothemes.com/
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// check theme 
$cur_theme = wp_get_theme();	
$token = get_option( 'verified_token' );
if( $cur_theme->get( 'Name' ) != 'Grankare' && $cur_theme->get( 'Name' ) != 'Grankare Child' ){
	return;
}
// check token
if( empty( $token ) ) return;

define( 'GRANKARE_ADDON_DIR', plugin_dir_path( __FILE__ ) );
define( 'GRANKARE_ADDON_URL', plugin_dir_url( __FILE__ ) );

/*
* Intialize and Sets up the plugin
*/
class Grankare_Addon {
	
	private static $_instance = null;
		
	/**
	* Sets up needed actions/filters for the plug-in to initialize.
	* @since 1.0.0
	* @access public
	* @return void
	*/
	public function __construct() {

		//$this->grankare_template_direct();

		// Get option
		$this->grankare_get_option_class();

		//Grankare addon setup page
		add_action('plugins_loaded', array( $this, 'grankare_elementor_addon_setup') );
		
		//Grankare addon shortcodes
		if( is_admin() ) add_action( 'init', array( $this, 'init_addons' ), 20 );
		
		add_action( 'init', array( $this, 'init_front_addons' ), 10 );

		//Create cuatom sidebars
		add_action( 'widgets_init', array( $this, 'grankare_sidebar_registration' ), 1 );
		
		//Connect all widgets
		$this->grankare_register_widgets();
		
		//Call all widgets
		add_action( 'widgets_init', array( $this, 'grankare_init_widgets' ), 1 );
		
		//WP actions
		$this->grankare_wp_action_setup();		

		//Custom functions
		$this->Grankare_Custom_Functions_setup();
		
		//WP admin tool bar menu
		add_action( 'admin_bar_menu', array( $this, 'grankare_add_toolbar_items' ), 100 );
		
	}
	
	/**
	* Installs translation text domain and checks if Elementor is installed
	* @since 1.0.0
	* @access public
	* @return void
	*/
	public function grankare_elementor_addon_setup() {
		//Load text domain
		$this->load_domain();
	}
	
	/**
	 * Load plugin translated strings using text domain
	 * @since 2.6.8
	 * @access public
	 * @return void
	 */
	public function load_domain() {
		load_plugin_textdomain( 'grankare-addon', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	public function grankare_template_direct(){
		/**
		* Maintenance or coming soon mode
		*/
		require_once ( GRANKARE_ADDON_DIR . 'maintenance/maintenance.php' );
	}

	public function grankare_get_option_class(){
		/**
		* Gte Theme options class
		*/
		require_once ( GRANKARE_ADDON_DIR . 'inc/class.theme-options.php' );

		/**
		* Maintenance or coming soon mode
		*/
		require_once ( GRANKARE_ADDON_DIR . 'maintenance/maintenance.php' );
	}
	
	
	/**
	* Load required file for addons integration
	* @return void
	*/
	public function init_addons() {
		
		/**
		* Plugin options class
		*/
		require_once ( GRANKARE_ADDON_DIR . 'admin/extension/theme-options/class.plugin-options.php' );

		/**
		* Post/Page options class
		*/
		require_once ( GRANKARE_ADDON_DIR . 'admin/extension/metabox/class.meta-box.php' );
		
		/**
		* Custom sidebar class
		*/
		require_once ( GRANKARE_ADDON_DIR . 'admin/extension/class.custom-sidebars.php' );
		
		/**
		* Custom fonts class
		*/
		require_once ( GRANKARE_ADDON_DIR . 'admin/extension/class.custom-fonts.php' );
		
		/**
		* Demo importer class
		*/
		require_once ( GRANKARE_ADDON_DIR . 'admin/extension/demo-importer/class.demo-importer.php' );

		$menu_type = Grankare_Theme_Option::grankare_options('menu-type');
		if( $menu_type == 'mega' ){
			require_once ( GRANKARE_ADDON_DIR . 'admin/extension/mega-menu/custom_menu.php' );
		}
				
	}

	public function init_front_addons(){
		$menu_type = Grankare_Theme_Option::grankare_options('menu-type');
		if( $menu_type == 'mega' ){
			require_once ( GRANKARE_ADDON_DIR . 'inc/class.mega-menu.php' );
		}
	}
	
	public function grankare_wp_action_setup(){
		
		/**
		* Wp actions
		*/
		require_once ( GRANKARE_ADDON_DIR . 'inc/wp-actions.php' );
		
	}

	public function grankare_sidebar_registration(){
		/**
		* Wp actions
		*/
		require_once ( GRANKARE_ADDON_DIR . 'inc/class.widgets-register.php' );		
	}

	public function grankare_register_widgets(){
		foreach ( glob( GRANKARE_ADDON_DIR . "widgets/*.php" ) as $filename) {
			include $filename;
		}
	}
	
	public function grankare_init_widgets(){
		//Call all widgets
		register_widget( 'Grankare_About_Widget' );
		register_widget( 'Grankare_Author_Widget' );
		register_widget( 'Grankare_Contact_Infos_Widget' );
		register_widget( 'Grankare_Latest_Post_Widget' );
		register_widget( 'Grankare_Mailchimp_Widget' );
		register_widget( 'Grankare_Popular_Post_Widget' );
		register_widget( 'Grankare_Social_Widget' );
		register_widget( 'Grankare_Advance_Tab_Post_Widget' );
	}

	public function Grankare_Custom_Functions_setup(){

		require_once ( GRANKARE_ADDON_DIR . 'inc/class.custom-functions.php' );	
		
		/**
		 * Detect plugin. For frontend only.
		 */
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		//Woo function
		if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			require_once ( GRANKARE_ADDON_DIR . 'inc/woo-functions.php' );	
		}
		
	}
	
	public function grankare_add_toolbar_items($admin_bar){
		$admin_bar->add_menu( array(
			'id'    => 'grankare-options',
			'title' => 'Grankare Options',
			'href'  => admin_url( 'admin.php?page=grankare-options' ),
			'meta'  => array(
				'title' => esc_html__( 'Grankare Options', 'grankare-addon' ),            
			),
		));
	}
	
	/**
	 * Creates and returns an instance of the class
	 * @since 2.6.8
	 * @access public
	 * return object
	 */
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Grankare_Addon::get_instance();