<?php

/**
 * Grankare Theme Options
 * @since 1.0.0
 */
final class Grankare_Plugin_Options { //grankare_admin_menu_out
	
	private static $_instance = null;
	
	public function __construct() {	
		add_action( 'admin_menu', array( $this, 'grankare_addon_options_menu' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'grankare_framework_admin_scripts' ) );
		$this->init();

		//import
		add_action( 'wp_ajax_bridddge-theme-option-import', array( $this, 'grankare_redux_themeopt_import' ) );

		//export
		add_action('wp_ajax_grankare-theme-options-export', array( $this, 'grankare_theme_options_export' ) );
		
	}
	
	public static function grankare_addon_options_menu(){
		add_submenu_page( 
			'grankare-welcome', 
			esc_html__( 'Theme Options', 'grankare-addon' ),
			esc_html__( 'Theme Options', 'grankare-addon' ), 
			'manage_options', 
			'grankare-options', 
			array( 'Grankare_Plugin_Options', 'grankare_options_admin_page' )
		);
	}
	
	public static function grankare_framework_admin_scripts(){
		if( isset( $_GET['page'] ) && $_GET['page'] == 'grankare-options' ){
			wp_enqueue_style( 'font-awesome', GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/css/font-awesome.min.css', array(), '4.7.0', 'all' );			
			wp_enqueue_style( 'bootstrap-icons', GRANKARE_URI . '/assets/css/bootstrap-icons.css', array(), '1.9.1', 'all' );
			
			wp_enqueue_media();
			wp_enqueue_style( 'grankare_theme_options_css', GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/css/theme-options.css', array(), '1.0', 'all' );
			wp_enqueue_style( 'wp-color-picker');
			wp_enqueue_script( 'wp-color-picker-alpha', GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/js/wp-color-picker-alpha.min.js', array( 'jquery', 'wp-color-picker' ), '3.0.0' );
			wp_enqueue_script( 'grankare_theme_options_js', GRANKARE_ADDON_URL . 'admin/extension/theme-options/assets/js/theme-options.js', array( 'jquery' ), '1.0', true );

			wp_localize_script( 'grankare_theme_options_js', 'grankare_ajax_object',
				array(
					'import_nonce' => wp_create_nonce( 'grankare-import-*&^F&' ),
					'export_nonce' => wp_create_nonce( 'grankare-export-&^%$)' ),
				)
			);

			require_once GRANKARE_ADDON_DIR . 'admin/extension/theme-options/googlefonts.php';
			$google_fonts = Grankare_Google_Fonts_Function::$_google_fonts;
			$google_fonts_arr = json_decode( $google_fonts, true );
			
			$extra_gf = array(
				"Spartan" => array(
					"variants" => array(
						array( "id" => "400", "name" => "Thin 100" ),
						array( "id" => "400", "name" => "Extra-light 200" ),
						array( "id" => "400", "name" => "Light 300" ),
						array( "id" => "400", "name" => "Regular 400" ),
						array( "id" => "400", "name" => "Medium 500" ),
						array( "id" => "400", "name" => "Semi-bold 600" ),
						array( "id" => "400", "name" => "Bold 700" ),
						array( "id" => "400", "name" => "Extra-bold 800" ),
						array( "id" => "400", "name" => "Black 900" )
					)
				)
			);
			if( is_array( $extra_gf ) && !empty( $extra_gf ) ){
				foreach( $extra_gf as $font => $details ) $google_fonts_arr[$font] = $details;
			}
			
			$google_fonts = json_encode( $google_fonts_arr );
			$google_fonts_vars = array(
				'google_fonts' => $google_fonts,
				'standard_font_variants' => Grankare_Google_Fonts_Function::$_standard_font_variants,
				'font_variants_default' => esc_html__( 'Font Weight &amp; Style', 'grankare-addon' ),
				'font_sub_default' => esc_html__( 'Font Subsets', 'grankare-addon' )
			);
			wp_localize_script( 'grankare_theme_options_js', 'google_fonts_vars', $google_fonts_vars );
			
		}
	}
	
	public function init() {
		require_once( GRANKARE_ADDON_DIR . 'admin/extension/theme-options/framework.php' );
		Grankare_Options::$opt_name = 'grankare_options';
	}
	
	public static function grankare_check_zhf(){
		/**
		 * Detect plugin. For frontend only.
		 */
		include_once ABSPATH . 'wp-admin/includes/plugin.php';

		// check zozo header footer actived
		if ( is_plugin_active( 'zozo-header-footer/zozo-header-footer.php' ) ) { ?>
			<div class="grankare-header-bar zhf-bar">
				<div class="grankare-header-left">
					<div class="grankare-admin-logo-inline">
						<img src="<?php echo esc_url( ZOZO_HF_CORE_URL . '/assets/images/zozo-logo.png' ); ?>" alt="zozo-logo">
					</div><!-- .grankare-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Zozo Header Footer Builder', 'grankare-addon' ); ?></h2>
				</div><!-- .grankare-header-left -->
				<div class="grankare-header-right">
					<p><strong><?php esc_html_e( 'You can make custom header through this elementor builder here', 'grankare-addon' ); ?> <span class="dashicons dashicons-arrow-right-alt"></span> </strong></p>
					<a href="<?php echo esc_url( admin_url( 'edit.php?post_type=zozo-hf' ) ); ?>" class="button grankare-btn"><?php esc_html_e( 'Goto Settings', 'grankare-addon' ); ?></a>
				</div><!-- .grankare-header-right -->
			</div><!-- .grankare-header-bar -->
		<?php
		} 
	}
		
	public static function grankare_options_admin_page(){	
		$grankare_theme = wp_get_theme(); ?>	
		<form method="post" action="#" enctype="multipart/form-data" id="grankare-plugin-form-wrapper">
			<div class="grankare-settings-wrap">
			
				<div class="grankare-header-bar">
					<div class="grankare-header-left">
						<div class="grankare-admin-logo-inline">
							<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="grankare-logo">
						</div><!-- .grankare-admin-logo-inline -->
						<h2 class="title"><?php esc_html_e( 'Grankare Options', 'grankare-addon' ); ?><span class="grankare-version"><?php echo esc_attr( $grankare_theme->get( 'Version' ) ); ?></span></h2>
					</div><!-- .grankare-header-left -->
					<div class="grankare-header-right">
						<button type="submit" class="button grankare-btn"><?php esc_html_e( 'Save Settings', 'grankare-addon' ); ?></button>
					</div><!-- .grankare-header-right -->
				</div><!-- .grankare-header-bar -->				
				
				<?php
					// check zhf installed
					self::grankare_check_zhf();				
				?>
				
				<div class="grankare-inner-wrap">
						
					<?php
						
						if ( isset( $_POST['save_grankare_theme_options'] ) && wp_verify_nonce( $_POST['save_grankare_theme_options'], 'grankare_theme_options*&^&*$' ) ) {
							update_option( 'grankare_options', $_POST['grankare_options'] );
							require_once ( GRANKARE_ADDON_DIR . 'admin/extension/theme-options/theme-options-css.php' );
						}
						
						//Get updated theme option
						Grankare_Options::$grankare_options = get_option('grankare_options');
						
						if( class_exists( 'Classic_Elementor_Addon' ) ){
							add_action( 'grankare_custom_template_options', function(){
								require_once GRANKARE_ADDON_DIR . 'admin/extension/theme-options/cea-config.php';
							});
						}
						
						//Theme config
						require_once GRANKARE_ADDON_DIR . 'admin/extension/theme-options/config.php';
						
					?>
					
					<div class="grankare-admin-content-wrap">
						<?php wp_nonce_field( 'grankare_theme_options*&^&*$', 'save_grankare_theme_options' ); ?>
						<div class="grankare-tab">
							<div class="grankare-tab-list">
								<ul class="tablinks-list">
									<?php Grankare_Options::grankare_put_section(); ?>
								</ul>
							</div><!-- .grankare-tab-list -->
							<div class="grankare-tab-contents">
								<?php Grankare_Options::grankare_put_field(); ?>
							</div><!-- .grankare-tab-contents -->
						</div><!-- .grankare-tab -->							
					</div><!-- .grankare-admin-content-wrap -->					
				</div><!-- .grankare-inner-wrap -->
			</div><!-- .grankare-settings-wrap -->
		</form>	
	<?php
	}

	public static function grankare_theme_options_export(){
		$nonce = $_POST['nonce'];	
		if ( ! wp_verify_nonce( $nonce, 'grankare-export-&^%$)' ) )
			die ( esc_html__( 'Busted!', 'grankare-addon' ) );
		
		$grankare_options = get_option( 'grankare_options');
		$grankare_options = is_array( $grankare_options ) ? array_map( 'stripslashes_deep', $grankare_options ) : stripslashes( $grankare_options );
		echo json_encode( $grankare_options );
		
		exit;
	}

	public static function grankare_redux_themeopt_import(){
		$nonce = $_POST['nonce'];		  
		if ( ! wp_verify_nonce( $nonce, 'grankare-import-*&^F&' ) )
			die ( esc_html__( 'Busted', 'grankare-addon' ) );
		
		$json_data = isset( $_POST['json_data'] ) ? stripslashes( urldecode( $_POST['json_data'] ) ) : '';
		$theme_opt_arr = json_decode( $json_data, true );
		if( !empty( $theme_opt_arr ) ){
			update_option( 'grankare_options', $theme_opt_arr );
		}
		
		wp_die('success');
	}
	
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

}

Grankare_Plugin_Options::instance();