<?php
/**
 * Archive template
 */

get_header();

Grankare_Wp_Elements::$template = 'archive';

?>

<main id="site-content">

	<?php 
		/*
		* Page title template call
		*/
		get_template_part( 'template-parts/page', 'title' );
	?>

	<div class="grankare-content-wrap container">
		<div class="row">
			<?php
				$content_col_class = Grankare_Wp_Elements::grankare_get_content_class();
			?>
			<div class="<?php echo esc_attr( $content_col_class ); ?>">
				<?php				
				if ( have_posts() ) { 
					echo '<div class="grankare-masonry" data-columns="2" data-gutter="30">';
						while ( have_posts() ) {
							the_post();
							get_template_part( 'template-parts/content', 'excerpt' );
						} 
					echo '</div>';		
				} elseif ( is_search() ) { ?>
					<div class="no-search-results-form">
						<div class="container">
							<h2 class="no-search-title"><?php esc_html_e( 'Nothing Found', 'grankare' ); ?></h2>
							<p class="no-search-results-desc"><?php esc_html_e( 'It seems we can not find what you are looking for. Perhaps searching can help. ', 'grankare' ); ?></p>
							<?php get_search_form(); ?>
						</div><!-- .container -->
					</div><!-- .no-search-results -->
					<?php
				}
				?>
				<?php get_template_part( 'template-parts/pagination' ); ?>
			</div><!-- .col -->
			<?php get_template_part( 'template-parts/content-sidebar' ); ?>
		</div><!-- .row -->
	</div><!-- .grankare-content-wrap -->

</main><!-- #site-content -->

<?php
get_footer();
