<?php
/**
 * Template coming soon default
 */
 
 //get maintenance header
 require_once( GRANKARE_ADDON_DIR . 'maintenance/header.php' );

 $address = Grankare_Theme_Option::grankare_options( 'maintenance-address' );
 $email = Grankare_Theme_Option::grankare_options( 'maintenance-email' );
 $phone = Grankare_Theme_Option::grankare_options( 'maintenance-phone' );
 
?>
<div class="container text-center maintenance-wrap">
	<div class="row">
		<div class="col-md-12">
			<h1 class="maintenance-title"><?php esc_html_e( 'Coming Soon', 'grankare-addon' ); ?></h1>
		</div>
	</div>
	<div class="row">
		<div class="col-md-4">
			<h4><?php esc_html_e( 'Phone', 'grankare-addon' ); ?></h4>
			<div class="maintenance-phone">
				<?php echo esc_html(  $phone ); ?>
			</div>
		</div>
		<div class="col-md-4">
			<h4><?php esc_html_e( 'Address', 'grankare-addon' ); ?></h4>
			<div class="maintenance-address">
				<?php echo wp_kses_post( $address ); ?>
			</div>
		</div>
		<div class="col-md-4">
			<h4><?php esc_html_e( 'Email', 'grankare-addon' ); ?></h4>
			<div class="maintenance-email">
				<?php echo esc_html(  $email ); ?>
			</div>
		</div>
	</div>
	
	<div class="row">
		<div class="col-md-12 maintenance-footer">
			<p><?php esc_html_e( 'We are currently working on an awesome new site, which will be ready soon. Stay Tuned!', 'grankare-addon' ); ?></p>
		</div>
	</div>
	
</div>
<?php
 //get maintenance header
 require_once( GRANKARE_ADDON_DIR . 'maintenance/footer.php' );
?>
